package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateEphemerisResponse(
    ephemerisId: Optional[Uuid] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.UpdateEphemerisResponse = {
    import UpdateEphemerisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.UpdateEphemerisResponse
      .builder()
      .optionallyWith(
        ephemerisId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.ephemerisId)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.UpdateEphemerisResponse.ReadOnly =
    zio.aws.groundstation.model.UpdateEphemerisResponse.wrap(buildAwsValue())
}
object UpdateEphemerisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.UpdateEphemerisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.UpdateEphemerisResponse =
      zio.aws.groundstation.model
        .UpdateEphemerisResponse(ephemerisId.map(value => value))
    def ephemerisId: Optional[Uuid]
    def getEphemerisId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("ephemerisId", ephemerisId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateEphemerisResponse
  ) extends zio.aws.groundstation.model.UpdateEphemerisResponse.ReadOnly {
    override val ephemerisId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.ephemerisId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateEphemerisResponse
  ): zio.aws.groundstation.model.UpdateEphemerisResponse.ReadOnly = new Wrapper(
    impl
  )
}
