package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.{UnboundedString, AnyArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: AnyArn,
    tagKeys: Iterable[UnboundedString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.UntagResourceRequest
      .builder()
      .resourceArn(AnyArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        UnboundedString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.UntagResourceRequest.ReadOnly =
    zio.aws.groundstation.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.UntagResourceRequest =
      zio.aws.groundstation.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: AnyArn
    def tagKeys: List[UnboundedString]
    def getResourceArn: ZIO[Any, Nothing, AnyArn] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[UnboundedString]] =
      ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.UntagResourceRequest
  ) extends zio.aws.groundstation.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: AnyArn =
      zio.aws.groundstation.model.primitives.AnyArn(impl.resourceArn())
    override val tagKeys: List[UnboundedString] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.groundstation.model.primitives.UnboundedString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.UntagResourceRequest
  ): zio.aws.groundstation.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
