package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.{TleLineTwo, TleLineOne}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TLEData(
    tleLine1: TleLineOne,
    tleLine2: TleLineTwo,
    validTimeRange: zio.aws.groundstation.model.TimeRange
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.TLEData = {
    import TLEData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.TLEData
      .builder()
      .tleLine1(TleLineOne.unwrap(tleLine1): java.lang.String)
      .tleLine2(TleLineTwo.unwrap(tleLine2): java.lang.String)
      .validTimeRange(validTimeRange.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.TLEData.ReadOnly =
    zio.aws.groundstation.model.TLEData.wrap(buildAwsValue())
}
object TLEData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.TLEData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.TLEData =
      zio.aws.groundstation.model
        .TLEData(tleLine1, tleLine2, validTimeRange.asEditable)
    def tleLine1: TleLineOne
    def tleLine2: TleLineTwo
    def validTimeRange: zio.aws.groundstation.model.TimeRange.ReadOnly
    def getTleLine1: ZIO[Any, Nothing, TleLineOne] = ZIO.succeed(tleLine1)
    def getTleLine2: ZIO[Any, Nothing, TleLineTwo] = ZIO.succeed(tleLine2)
    def getValidTimeRange
        : ZIO[Any, Nothing, zio.aws.groundstation.model.TimeRange.ReadOnly] =
      ZIO.succeed(validTimeRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.TLEData
  ) extends zio.aws.groundstation.model.TLEData.ReadOnly {
    override val tleLine1: TleLineOne =
      zio.aws.groundstation.model.primitives.TleLineOne(impl.tleLine1())
    override val tleLine2: TleLineTwo =
      zio.aws.groundstation.model.primitives.TleLineTwo(impl.tleLine2())
    override val validTimeRange
        : zio.aws.groundstation.model.TimeRange.ReadOnly =
      zio.aws.groundstation.model.TimeRange.wrap(impl.validTimeRange())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.TLEData
  ): zio.aws.groundstation.model.TLEData.ReadOnly = new Wrapper(impl)
}
