package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SpectrumConfig(
    bandwidth: zio.aws.groundstation.model.FrequencyBandwidth,
    centerFrequency: zio.aws.groundstation.model.Frequency,
    polarization: Optional[zio.aws.groundstation.model.Polarization] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.SpectrumConfig = {
    import SpectrumConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.SpectrumConfig
      .builder()
      .bandwidth(bandwidth.buildAwsValue())
      .centerFrequency(centerFrequency.buildAwsValue())
      .optionallyWith(polarization.map(value => value.unwrap))(_.polarization)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.SpectrumConfig.ReadOnly =
    zio.aws.groundstation.model.SpectrumConfig.wrap(buildAwsValue())
}
object SpectrumConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.SpectrumConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.SpectrumConfig =
      zio.aws.groundstation.model.SpectrumConfig(
        bandwidth.asEditable,
        centerFrequency.asEditable,
        polarization.map(value => value)
      )
    def bandwidth: zio.aws.groundstation.model.FrequencyBandwidth.ReadOnly
    def centerFrequency: zio.aws.groundstation.model.Frequency.ReadOnly
    def polarization: Optional[zio.aws.groundstation.model.Polarization]
    def getBandwidth: ZIO[
      Any,
      Nothing,
      zio.aws.groundstation.model.FrequencyBandwidth.ReadOnly
    ] = ZIO.succeed(bandwidth)
    def getCenterFrequency
        : ZIO[Any, Nothing, zio.aws.groundstation.model.Frequency.ReadOnly] =
      ZIO.succeed(centerFrequency)
    def getPolarization
        : ZIO[Any, AwsError, zio.aws.groundstation.model.Polarization] =
      AwsError.unwrapOptionField("polarization", polarization)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.SpectrumConfig
  ) extends zio.aws.groundstation.model.SpectrumConfig.ReadOnly {
    override val bandwidth
        : zio.aws.groundstation.model.FrequencyBandwidth.ReadOnly =
      zio.aws.groundstation.model.FrequencyBandwidth.wrap(impl.bandwidth())
    override val centerFrequency
        : zio.aws.groundstation.model.Frequency.ReadOnly =
      zio.aws.groundstation.model.Frequency.wrap(impl.centerFrequency())
    override val polarization
        : Optional[zio.aws.groundstation.model.Polarization] =
      zio.aws.core.internal
        .optionalFromNullable(impl.polarization())
        .map(value => zio.aws.groundstation.model.Polarization.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.SpectrumConfig
  ): zio.aws.groundstation.model.SpectrumConfig.ReadOnly = new Wrapper(impl)
}
