package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.{RoleArn, S3KeyPrefix, BucketArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3RecordingConfig(
    bucketArn: BucketArn,
    prefix: Optional[S3KeyPrefix] = Optional.Absent,
    roleArn: RoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.S3RecordingConfig = {
    import S3RecordingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.S3RecordingConfig
      .builder()
      .bucketArn(BucketArn.unwrap(bucketArn): java.lang.String)
      .optionallyWith(
        prefix.map(value => S3KeyPrefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.S3RecordingConfig.ReadOnly =
    zio.aws.groundstation.model.S3RecordingConfig.wrap(buildAwsValue())
}
object S3RecordingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.S3RecordingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.S3RecordingConfig =
      zio.aws.groundstation.model
        .S3RecordingConfig(bucketArn, prefix.map(value => value), roleArn)
    def bucketArn: BucketArn
    def prefix: Optional[S3KeyPrefix]
    def roleArn: RoleArn
    def getBucketArn: ZIO[Any, Nothing, BucketArn] = ZIO.succeed(bucketArn)
    def getPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.S3RecordingConfig
  ) extends zio.aws.groundstation.model.S3RecordingConfig.ReadOnly {
    override val bucketArn: BucketArn =
      zio.aws.groundstation.model.primitives.BucketArn(impl.bucketArn())
    override val prefix: Optional[S3KeyPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.groundstation.model.primitives.S3KeyPrefix(value))
    override val roleArn: RoleArn =
      zio.aws.groundstation.model.primitives.RoleArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.S3RecordingConfig
  ): zio.aws.groundstation.model.S3RecordingConfig.ReadOnly = new Wrapper(impl)
}
