package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReserveContactResponse(
    contactId: Optional[Uuid] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ReserveContactResponse = {
    import ReserveContactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ReserveContactResponse
      .builder()
      .optionallyWith(
        contactId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.contactId)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ReserveContactResponse.ReadOnly =
    zio.aws.groundstation.model.ReserveContactResponse.wrap(buildAwsValue())
}
object ReserveContactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ReserveContactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ReserveContactResponse =
      zio.aws.groundstation.model
        .ReserveContactResponse(contactId.map(value => value))
    def contactId: Optional[Uuid]
    def getContactId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("contactId", contactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ReserveContactResponse
  ) extends zio.aws.groundstation.model.ReserveContactResponse.ReadOnly {
    override val contactId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.contactId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ReserveContactResponse
  ): zio.aws.groundstation.model.ReserveContactResponse.ReadOnly = new Wrapper(
    impl
  )
}
