package zio.aws.groundstation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{
  SatelliteArn,
  MissionProfileArn,
  GroundStationName,
  Timestamp
}
import scala.jdk.CollectionConverters._
final case class ReserveContactRequest(
    endTime: Timestamp,
    groundStation: GroundStationName,
    missionProfileArn: MissionProfileArn,
    satelliteArn: SatelliteArn,
    startTime: Timestamp,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ReserveContactRequest = {
    import ReserveContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ReserveContactRequest
      .builder()
      .endTime(Timestamp.unwrap(endTime): Instant)
      .groundStation(GroundStationName.unwrap(groundStation): java.lang.String)
      .missionProfileArn(
        MissionProfileArn.unwrap(missionProfileArn): java.lang.String
      )
      .satelliteArn(SatelliteArn.unwrap(satelliteArn): java.lang.String)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ReserveContactRequest.ReadOnly =
    zio.aws.groundstation.model.ReserveContactRequest.wrap(buildAwsValue())
}
object ReserveContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ReserveContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ReserveContactRequest =
      zio.aws.groundstation.model.ReserveContactRequest(
        endTime,
        groundStation,
        missionProfileArn,
        satelliteArn,
        startTime,
        tags.map(value => value)
      )
    def endTime: Timestamp
    def groundStation: GroundStationName
    def missionProfileArn: MissionProfileArn
    def satelliteArn: SatelliteArn
    def startTime: Timestamp
    def tags: Optional[Map[String, String]]
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getGroundStation: ZIO[Any, Nothing, GroundStationName] =
      ZIO.succeed(groundStation)
    def getMissionProfileArn: ZIO[Any, Nothing, MissionProfileArn] =
      ZIO.succeed(missionProfileArn)
    def getSatelliteArn: ZIO[Any, Nothing, SatelliteArn] =
      ZIO.succeed(satelliteArn)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ReserveContactRequest
  ) extends zio.aws.groundstation.model.ReserveContactRequest.ReadOnly {
    override val endTime: Timestamp =
      zio.aws.groundstation.model.primitives.Timestamp(impl.endTime())
    override val groundStation: GroundStationName =
      zio.aws.groundstation.model.primitives
        .GroundStationName(impl.groundStation())
    override val missionProfileArn: MissionProfileArn =
      zio.aws.groundstation.model.primitives
        .MissionProfileArn(impl.missionProfileArn())
    override val satelliteArn: SatelliteArn =
      zio.aws.groundstation.model.primitives.SatelliteArn(impl.satelliteArn())
    override val startTime: Timestamp =
      zio.aws.groundstation.model.primitives.Timestamp(impl.startTime())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ReserveContactRequest
  ): zio.aws.groundstation.model.ReserveContactRequest.ReadOnly = new Wrapper(
    impl
  )
}
