package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.IpV4Address
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RangedSocketAddress(
    name: IpV4Address,
    portRange: zio.aws.groundstation.model.IntegerRange
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.RangedSocketAddress = {
    import RangedSocketAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.RangedSocketAddress
      .builder()
      .name(IpV4Address.unwrap(name): java.lang.String)
      .portRange(portRange.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.RangedSocketAddress.ReadOnly =
    zio.aws.groundstation.model.RangedSocketAddress.wrap(buildAwsValue())
}
object RangedSocketAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.RangedSocketAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.RangedSocketAddress =
      zio.aws.groundstation.model
        .RangedSocketAddress(name, portRange.asEditable)
    def name: IpV4Address
    def portRange: zio.aws.groundstation.model.IntegerRange.ReadOnly
    def getName: ZIO[Any, Nothing, IpV4Address] = ZIO.succeed(name)
    def getPortRange
        : ZIO[Any, Nothing, zio.aws.groundstation.model.IntegerRange.ReadOnly] =
      ZIO.succeed(portRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.RangedSocketAddress
  ) extends zio.aws.groundstation.model.RangedSocketAddress.ReadOnly {
    override val name: IpV4Address =
      zio.aws.groundstation.model.primitives.IpV4Address(impl.name())
    override val portRange: zio.aws.groundstation.model.IntegerRange.ReadOnly =
      zio.aws.groundstation.model.IntegerRange.wrap(impl.portRange())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.RangedSocketAddress
  ): zio.aws.groundstation.model.RangedSocketAddress.ReadOnly = new Wrapper(
    impl
  )
}
