package zio.aws.groundstation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.RangedConnectionDetailsMtuInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RangedConnectionDetails(
    mtu: Optional[RangedConnectionDetailsMtuInteger] = Optional.Absent,
    socketAddress: zio.aws.groundstation.model.RangedSocketAddress
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.RangedConnectionDetails = {
    import RangedConnectionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.RangedConnectionDetails
      .builder()
      .optionallyWith(
        mtu.map(value =>
          RangedConnectionDetailsMtuInteger.unwrap(value): Integer
        )
      )(_.mtu)
      .socketAddress(socketAddress.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.RangedConnectionDetails.ReadOnly =
    zio.aws.groundstation.model.RangedConnectionDetails.wrap(buildAwsValue())
}
object RangedConnectionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.RangedConnectionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.RangedConnectionDetails =
      zio.aws.groundstation.model.RangedConnectionDetails(
        mtu.map(value => value),
        socketAddress.asEditable
      )
    def mtu: Optional[RangedConnectionDetailsMtuInteger]
    def socketAddress: zio.aws.groundstation.model.RangedSocketAddress.ReadOnly
    def getMtu: ZIO[Any, AwsError, RangedConnectionDetailsMtuInteger] =
      AwsError.unwrapOptionField("mtu", mtu)
    def getSocketAddress: ZIO[
      Any,
      Nothing,
      zio.aws.groundstation.model.RangedSocketAddress.ReadOnly
    ] = ZIO.succeed(socketAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.RangedConnectionDetails
  ) extends zio.aws.groundstation.model.RangedConnectionDetails.ReadOnly {
    override val mtu: Optional[RangedConnectionDetailsMtuInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mtu())
        .map(value =>
          zio.aws.groundstation.model.primitives
            .RangedConnectionDetailsMtuInteger(value)
        )
    override val socketAddress
        : zio.aws.groundstation.model.RangedSocketAddress.ReadOnly =
      zio.aws.groundstation.model.RangedSocketAddress.wrap(impl.socketAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.RangedConnectionDetails
  ): zio.aws.groundstation.model.RangedConnectionDetails.ReadOnly = new Wrapper(
    impl
  )
}
