package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.UnboundedString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OEMEphemeris(
    oemData: Optional[UnboundedString] = Optional.Absent,
    s3Object: Optional[zio.aws.groundstation.model.S3Object] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.OEMEphemeris = {
    import OEMEphemeris.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.OEMEphemeris
      .builder()
      .optionallyWith(
        oemData.map(value => UnboundedString.unwrap(value): java.lang.String)
      )(_.oemData)
      .optionallyWith(s3Object.map(value => value.buildAwsValue()))(_.s3Object)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.OEMEphemeris.ReadOnly =
    zio.aws.groundstation.model.OEMEphemeris.wrap(buildAwsValue())
}
object OEMEphemeris {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.OEMEphemeris
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.OEMEphemeris =
      zio.aws.groundstation.model.OEMEphemeris(
        oemData.map(value => value),
        s3Object.map(value => value.asEditable)
      )
    def oemData: Optional[UnboundedString]
    def s3Object: Optional[zio.aws.groundstation.model.S3Object.ReadOnly]
    def getOemData: ZIO[Any, AwsError, UnboundedString] =
      AwsError.unwrapOptionField("oemData", oemData)
    def getS3Object
        : ZIO[Any, AwsError, zio.aws.groundstation.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("s3Object", s3Object)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.OEMEphemeris
  ) extends zio.aws.groundstation.model.OEMEphemeris.ReadOnly {
    override val oemData: Optional[UnboundedString] = zio.aws.core.internal
      .optionalFromNullable(impl.oemData())
      .map(value =>
        zio.aws.groundstation.model.primitives.UnboundedString(value)
      )
    override val s3Object
        : Optional[zio.aws.groundstation.model.S3Object.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Object())
        .map(value => zio.aws.groundstation.model.S3Object.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.OEMEphemeris
  ): zio.aws.groundstation.model.OEMEphemeris.ReadOnly = new Wrapper(impl)
}
