package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListConfigsResponse(
    configList: Optional[Iterable[zio.aws.groundstation.model.ConfigListItem]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListConfigsResponse = {
    import ListConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListConfigsResponse
      .builder()
      .optionallyWith(
        configList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ListConfigsResponse.ReadOnly =
    zio.aws.groundstation.model.ListConfigsResponse.wrap(buildAwsValue())
}
object ListConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ListConfigsResponse =
      zio.aws.groundstation.model.ListConfigsResponse(
        configList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def configList
        : Optional[List[zio.aws.groundstation.model.ConfigListItem.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getConfigList: ZIO[Any, AwsError, List[
      zio.aws.groundstation.model.ConfigListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("configList", configList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListConfigsResponse
  ) extends zio.aws.groundstation.model.ListConfigsResponse.ReadOnly {
    override val configList
        : Optional[List[zio.aws.groundstation.model.ConfigListItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.groundstation.model.ConfigListItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.groundstation.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListConfigsResponse
  ): zio.aws.groundstation.model.ListConfigsResponse.ReadOnly = new Wrapper(
    impl
  )
}
