package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.{
  KeyArn,
  KeyAliasName,
  KeyAliasArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KmsKey(
    kmsAliasArn: Optional[KeyAliasArn] = Optional.Absent,
    kmsAliasName: Optional[KeyAliasName] = Optional.Absent,
    kmsKeyArn: Optional[KeyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.KmsKey = {
    import KmsKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.KmsKey
      .builder()
      .optionallyWith(
        kmsAliasArn.map(value => KeyAliasArn.unwrap(value): java.lang.String)
      )(_.kmsAliasArn)
      .optionallyWith(
        kmsAliasName.map(value => KeyAliasName.unwrap(value): java.lang.String)
      )(_.kmsAliasName)
      .optionallyWith(
        kmsKeyArn.map(value => KeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.KmsKey.ReadOnly =
    zio.aws.groundstation.model.KmsKey.wrap(buildAwsValue())
}
object KmsKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.KmsKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.KmsKey =
      zio.aws.groundstation.model.KmsKey(
        kmsAliasArn.map(value => value),
        kmsAliasName.map(value => value),
        kmsKeyArn.map(value => value)
      )
    def kmsAliasArn: Optional[KeyAliasArn]
    def kmsAliasName: Optional[KeyAliasName]
    def kmsKeyArn: Optional[KeyArn]
    def getKmsAliasArn: ZIO[Any, AwsError, KeyAliasArn] =
      AwsError.unwrapOptionField("kmsAliasArn", kmsAliasArn)
    def getKmsAliasName: ZIO[Any, AwsError, KeyAliasName] =
      AwsError.unwrapOptionField("kmsAliasName", kmsAliasName)
    def getKmsKeyArn: ZIO[Any, AwsError, KeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.KmsKey
  ) extends zio.aws.groundstation.model.KmsKey.ReadOnly {
    override val kmsAliasArn: Optional[KeyAliasArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsAliasArn())
      .map(value => zio.aws.groundstation.model.primitives.KeyAliasArn(value))
    override val kmsAliasName: Optional[KeyAliasName] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsAliasName())
      .map(value => zio.aws.groundstation.model.primitives.KeyAliasName(value))
    override val kmsKeyArn: Optional[KeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.groundstation.model.primitives.KeyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.KmsKey
  ): zio.aws.groundstation.model.KmsKey.ReadOnly = new Wrapper(impl)
}
