package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetMinuteUsageResponse(
    estimatedMinutesRemaining: Optional[Integer] = Optional.Absent,
    isReservedMinutesCustomer: Optional[Boolean] = Optional.Absent,
    totalReservedMinuteAllocation: Optional[Integer] = Optional.Absent,
    totalScheduledMinutes: Optional[Integer] = Optional.Absent,
    upcomingMinutesScheduled: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GetMinuteUsageResponse = {
    import GetMinuteUsageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GetMinuteUsageResponse
      .builder()
      .optionallyWith(
        estimatedMinutesRemaining.map(value => value: java.lang.Integer)
      )(_.estimatedMinutesRemaining)
      .optionallyWith(
        isReservedMinutesCustomer.map(value => value: java.lang.Boolean)
      )(_.isReservedMinutesCustomer)
      .optionallyWith(
        totalReservedMinuteAllocation.map(value => value: java.lang.Integer)
      )(_.totalReservedMinuteAllocation)
      .optionallyWith(
        totalScheduledMinutes.map(value => value: java.lang.Integer)
      )(_.totalScheduledMinutes)
      .optionallyWith(
        upcomingMinutesScheduled.map(value => value: java.lang.Integer)
      )(_.upcomingMinutesScheduled)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.GetMinuteUsageResponse.ReadOnly =
    zio.aws.groundstation.model.GetMinuteUsageResponse.wrap(buildAwsValue())
}
object GetMinuteUsageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GetMinuteUsageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.GetMinuteUsageResponse =
      zio.aws.groundstation.model.GetMinuteUsageResponse(
        estimatedMinutesRemaining.map(value => value),
        isReservedMinutesCustomer.map(value => value),
        totalReservedMinuteAllocation.map(value => value),
        totalScheduledMinutes.map(value => value),
        upcomingMinutesScheduled.map(value => value)
      )
    def estimatedMinutesRemaining: Optional[Integer]
    def isReservedMinutesCustomer: Optional[Boolean]
    def totalReservedMinuteAllocation: Optional[Integer]
    def totalScheduledMinutes: Optional[Integer]
    def upcomingMinutesScheduled: Optional[Integer]
    def getEstimatedMinutesRemaining: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("estimatedMinutesRemaining", estimatedMinutesRemaining)
    def getIsReservedMinutesCustomer: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("isReservedMinutesCustomer", isReservedMinutesCustomer)
    def getTotalReservedMinuteAllocation: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "totalReservedMinuteAllocation",
        totalReservedMinuteAllocation
      )
    def getTotalScheduledMinutes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalScheduledMinutes", totalScheduledMinutes)
    def getUpcomingMinutesScheduled: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("upcomingMinutesScheduled", upcomingMinutesScheduled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GetMinuteUsageResponse
  ) extends zio.aws.groundstation.model.GetMinuteUsageResponse.ReadOnly {
    override val estimatedMinutesRemaining: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedMinutesRemaining())
        .map(value => value: Integer)
    override val isReservedMinutesCustomer: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isReservedMinutesCustomer())
        .map(value => value: Boolean)
    override val totalReservedMinuteAllocation: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalReservedMinuteAllocation())
        .map(value => value: Integer)
    override val totalScheduledMinutes: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalScheduledMinutes())
        .map(value => value: Integer)
    override val upcomingMinutesScheduled: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.upcomingMinutesScheduled())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GetMinuteUsageResponse
  ): zio.aws.groundstation.model.GetMinuteUsageResponse.ReadOnly = new Wrapper(
    impl
  )
}
