package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetConfigRequest(
    configId: Uuid,
    configType: zio.aws.groundstation.model.ConfigCapabilityType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GetConfigRequest = {
    import GetConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GetConfigRequest
      .builder()
      .configId(Uuid.unwrap(configId): java.lang.String)
      .configType(configType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.GetConfigRequest.ReadOnly =
    zio.aws.groundstation.model.GetConfigRequest.wrap(buildAwsValue())
}
object GetConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GetConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.GetConfigRequest =
      zio.aws.groundstation.model.GetConfigRequest(configId, configType)
    def configId: Uuid
    def configType: zio.aws.groundstation.model.ConfigCapabilityType
    def getConfigId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(configId)
    def getConfigType
        : ZIO[Any, Nothing, zio.aws.groundstation.model.ConfigCapabilityType] =
      ZIO.succeed(configType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GetConfigRequest
  ) extends zio.aws.groundstation.model.GetConfigRequest.ReadOnly {
    override val configId: Uuid =
      zio.aws.groundstation.model.primitives.Uuid(impl.configId())
    override val configType: zio.aws.groundstation.model.ConfigCapabilityType =
      zio.aws.groundstation.model.ConfigCapabilityType.wrap(impl.configType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GetConfigRequest
  ): zio.aws.groundstation.model.GetConfigRequest.ReadOnly = new Wrapper(impl)
}
