package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Frequency(
    units: zio.aws.groundstation.model.FrequencyUnits,
    value: Double
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.Frequency = {
    import Frequency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.Frequency
      .builder()
      .units(units.unwrap)
      .value(value: java.lang.Double)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.Frequency.ReadOnly =
    zio.aws.groundstation.model.Frequency.wrap(buildAwsValue())
}
object Frequency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.Frequency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.Frequency =
      zio.aws.groundstation.model.Frequency(units, value)
    def units: zio.aws.groundstation.model.FrequencyUnits
    def value: Double
    def getUnits
        : ZIO[Any, Nothing, zio.aws.groundstation.model.FrequencyUnits] =
      ZIO.succeed(units)
    def getValue: ZIO[Any, Nothing, Double] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.Frequency
  ) extends zio.aws.groundstation.model.Frequency.ReadOnly {
    override val units: zio.aws.groundstation.model.FrequencyUnits =
      zio.aws.groundstation.model.FrequencyUnits.wrap(impl.units())
    override val value: Double = impl.value(): Double
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.Frequency
  ): zio.aws.groundstation.model.Frequency.ReadOnly = new Wrapper(impl)
}
