package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EphemerisTypeDescription(
    oem: Optional[zio.aws.groundstation.model.EphemerisDescription] =
      Optional.Absent,
    tle: Optional[zio.aws.groundstation.model.EphemerisDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.EphemerisTypeDescription = {
    import EphemerisTypeDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.EphemerisTypeDescription
      .builder()
      .optionallyWith(oem.map(value => value.buildAwsValue()))(_.oem)
      .optionallyWith(tle.map(value => value.buildAwsValue()))(_.tle)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.EphemerisTypeDescription.ReadOnly =
    zio.aws.groundstation.model.EphemerisTypeDescription.wrap(buildAwsValue())
}
object EphemerisTypeDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.EphemerisTypeDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.EphemerisTypeDescription =
      zio.aws.groundstation.model.EphemerisTypeDescription(
        oem.map(value => value.asEditable),
        tle.map(value => value.asEditable)
      )
    def oem: Optional[zio.aws.groundstation.model.EphemerisDescription.ReadOnly]
    def tle: Optional[zio.aws.groundstation.model.EphemerisDescription.ReadOnly]
    def getOem: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.EphemerisDescription.ReadOnly
    ] = AwsError.unwrapOptionField("oem", oem)
    def getTle: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.EphemerisDescription.ReadOnly
    ] = AwsError.unwrapOptionField("tle", tle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.EphemerisTypeDescription
  ) extends zio.aws.groundstation.model.EphemerisTypeDescription.ReadOnly {
    override val oem
        : Optional[zio.aws.groundstation.model.EphemerisDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oem())
        .map(value =>
          zio.aws.groundstation.model.EphemerisDescription.wrap(value)
        )
    override val tle
        : Optional[zio.aws.groundstation.model.EphemerisDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tle())
        .map(value =>
          zio.aws.groundstation.model.EphemerisDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.EphemerisTypeDescription
  ): zio.aws.groundstation.model.EphemerisTypeDescription.ReadOnly =
    new Wrapper(impl)
}
