package zio.aws.groundstation.model
import scala.jdk.CollectionConverters._
sealed trait EphemerisSource {
  def unwrap
      : software.amazon.awssdk.services.groundstation.model.EphemerisSource
}
object EphemerisSource {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.EphemerisSource
  ): zio.aws.groundstation.model.EphemerisSource = value match {
    case software.amazon.awssdk.services.groundstation.model.EphemerisSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.EphemerisSource.CUSTOMER_PROVIDED =>
      val r = CUSTOMER_PROVIDED
      r
    case software.amazon.awssdk.services.groundstation.model.EphemerisSource.SPACE_TRACK =>
      val r = SPACE_TRACK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.EphemerisSource {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisSource =
      software.amazon.awssdk.services.groundstation.model.EphemerisSource.UNKNOWN_TO_SDK_VERSION
  }
  case object CUSTOMER_PROVIDED
      extends zio.aws.groundstation.model.EphemerisSource {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisSource =
      software.amazon.awssdk.services.groundstation.model.EphemerisSource.CUSTOMER_PROVIDED
  }
  case object SPACE_TRACK extends zio.aws.groundstation.model.EphemerisSource {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisSource =
      software.amazon.awssdk.services.groundstation.model.EphemerisSource.SPACE_TRACK
  }
}
