package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EphemerisData(
    oem: Optional[zio.aws.groundstation.model.OEMEphemeris] = Optional.Absent,
    tle: Optional[zio.aws.groundstation.model.TLEEphemeris] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.EphemerisData = {
    import EphemerisData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.EphemerisData
      .builder()
      .optionallyWith(oem.map(value => value.buildAwsValue()))(_.oem)
      .optionallyWith(tle.map(value => value.buildAwsValue()))(_.tle)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.EphemerisData.ReadOnly =
    zio.aws.groundstation.model.EphemerisData.wrap(buildAwsValue())
}
object EphemerisData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.EphemerisData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.EphemerisData =
      zio.aws.groundstation.model.EphemerisData(
        oem.map(value => value.asEditable),
        tle.map(value => value.asEditable)
      )
    def oem: Optional[zio.aws.groundstation.model.OEMEphemeris.ReadOnly]
    def tle: Optional[zio.aws.groundstation.model.TLEEphemeris.ReadOnly]
    def getOem: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.OEMEphemeris.ReadOnly
    ] = AwsError.unwrapOptionField("oem", oem)
    def getTle: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.TLEEphemeris.ReadOnly
    ] = AwsError.unwrapOptionField("tle", tle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.EphemerisData
  ) extends zio.aws.groundstation.model.EphemerisData.ReadOnly {
    override val oem
        : Optional[zio.aws.groundstation.model.OEMEphemeris.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oem())
        .map(value => zio.aws.groundstation.model.OEMEphemeris.wrap(value))
    override val tle
        : Optional[zio.aws.groundstation.model.TLEEphemeris.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tle())
        .map(value => zio.aws.groundstation.model.TLEEphemeris.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.EphemerisData
  ): zio.aws.groundstation.model.EphemerisData.ReadOnly = new Wrapper(impl)
}
