package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Elevation(
    unit: zio.aws.groundstation.model.AngleUnits,
    value: Double
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.Elevation = {
    import Elevation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.Elevation
      .builder()
      .unit(unit.unwrap)
      .value(value: java.lang.Double)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.Elevation.ReadOnly =
    zio.aws.groundstation.model.Elevation.wrap(buildAwsValue())
}
object Elevation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.Elevation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.Elevation =
      zio.aws.groundstation.model.Elevation(unit, value)
    def unit: zio.aws.groundstation.model.AngleUnits
    def value: Double
    def getUnit: ZIO[Any, Nothing, zio.aws.groundstation.model.AngleUnits] =
      ZIO.succeed(unit)
    def getValue: ZIO[Any, Nothing, Double] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.Elevation
  ) extends zio.aws.groundstation.model.Elevation.ReadOnly {
    override val unit: zio.aws.groundstation.model.AngleUnits =
      zio.aws.groundstation.model.AngleUnits.wrap(impl.unit())
    override val value: Double = impl.value(): Double
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.Elevation
  ): zio.aws.groundstation.model.Elevation.ReadOnly = new Wrapper(impl)
}
