package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteEphemerisResponse(
    ephemerisId: Optional[Uuid] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DeleteEphemerisResponse = {
    import DeleteEphemerisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DeleteEphemerisResponse
      .builder()
      .optionallyWith(
        ephemerisId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.ephemerisId)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.DeleteEphemerisResponse.ReadOnly =
    zio.aws.groundstation.model.DeleteEphemerisResponse.wrap(buildAwsValue())
}
object DeleteEphemerisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DeleteEphemerisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DeleteEphemerisResponse =
      zio.aws.groundstation.model
        .DeleteEphemerisResponse(ephemerisId.map(value => value))
    def ephemerisId: Optional[Uuid]
    def getEphemerisId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("ephemerisId", ephemerisId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DeleteEphemerisResponse
  ) extends zio.aws.groundstation.model.DeleteEphemerisResponse.ReadOnly {
    override val ephemerisId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.ephemerisId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DeleteEphemerisResponse
  ): zio.aws.groundstation.model.DeleteEphemerisResponse.ReadOnly = new Wrapper(
    impl
  )
}
