package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataflowEndpointConfig(
    dataflowEndpointName: String,
    dataflowEndpointRegion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DataflowEndpointConfig = {
    import DataflowEndpointConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DataflowEndpointConfig
      .builder()
      .dataflowEndpointName(dataflowEndpointName: java.lang.String)
      .optionallyWith(
        dataflowEndpointRegion.map(value => value: java.lang.String)
      )(_.dataflowEndpointRegion)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.DataflowEndpointConfig.ReadOnly =
    zio.aws.groundstation.model.DataflowEndpointConfig.wrap(buildAwsValue())
}
object DataflowEndpointConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DataflowEndpointConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DataflowEndpointConfig =
      zio.aws.groundstation.model.DataflowEndpointConfig(
        dataflowEndpointName,
        dataflowEndpointRegion.map(value => value)
      )
    def dataflowEndpointName: String
    def dataflowEndpointRegion: Optional[String]
    def getDataflowEndpointName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dataflowEndpointName)
    def getDataflowEndpointRegion: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dataflowEndpointRegion", dataflowEndpointRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DataflowEndpointConfig
  ) extends zio.aws.groundstation.model.DataflowEndpointConfig.ReadOnly {
    override val dataflowEndpointName: String =
      impl.dataflowEndpointName(): String
    override val dataflowEndpointRegion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataflowEndpointRegion())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DataflowEndpointConfig
  ): zio.aws.groundstation.model.DataflowEndpointConfig.ReadOnly = new Wrapper(
    impl
  )
}
