package zio.aws.groundstation.model
import scala.jdk.CollectionConverters._
sealed trait Criticality {
  def unwrap: software.amazon.awssdk.services.groundstation.model.Criticality
}
object Criticality {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.Criticality
  ): zio.aws.groundstation.model.Criticality = value match {
    case software.amazon.awssdk.services.groundstation.model.Criticality.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.Criticality.PREFERRED =>
      val r = PREFERRED
      r
    case software.amazon.awssdk.services.groundstation.model.Criticality.REMOVED =>
      val r = REMOVED
      r
    case software.amazon.awssdk.services.groundstation.model.Criticality.REQUIRED =>
      val r = REQUIRED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.Criticality {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.Criticality =
      software.amazon.awssdk.services.groundstation.model.Criticality.UNKNOWN_TO_SDK_VERSION
  }
  case object PREFERRED extends zio.aws.groundstation.model.Criticality {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.Criticality =
      software.amazon.awssdk.services.groundstation.model.Criticality.PREFERRED
  }
  case object REMOVED extends zio.aws.groundstation.model.Criticality {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.Criticality =
      software.amazon.awssdk.services.groundstation.model.Criticality.REMOVED
  }
  case object REQUIRED extends zio.aws.groundstation.model.Criticality {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.Criticality =
      software.amazon.awssdk.services.groundstation.model.Criticality.REQUIRED
  }
}
