package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDataflowEndpointGroupResponse(
    dataflowEndpointGroupId: Optional[Uuid] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupResponse = {
    import CreateDataflowEndpointGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupResponse
      .builder()
      .optionallyWith(
        dataflowEndpointGroupId.map(value =>
          Uuid.unwrap(value): java.lang.String
        )
      )(_.dataflowEndpointGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse.ReadOnly =
    zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse
      .wrap(buildAwsValue())
}
object CreateDataflowEndpointGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse =
      zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse(
        dataflowEndpointGroupId.map(value => value)
      )
    def dataflowEndpointGroupId: Optional[Uuid]
    def getDataflowEndpointGroupId: ZIO[Any, AwsError, Uuid] = AwsError
      .unwrapOptionField("dataflowEndpointGroupId", dataflowEndpointGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupResponse
  ) extends zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse.ReadOnly {
    override val dataflowEndpointGroupId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.dataflowEndpointGroupId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupResponse
  ): zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse.ReadOnly =
    new Wrapper(impl)
}
