package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.ConfigArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConfigListItem(
    configArn: Optional[ConfigArn] = Optional.Absent,
    configId: Optional[String] = Optional.Absent,
    configType: Optional[zio.aws.groundstation.model.ConfigCapabilityType] =
      Optional.Absent,
    name: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ConfigListItem = {
    import ConfigListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ConfigListItem
      .builder()
      .optionallyWith(
        configArn.map(value => ConfigArn.unwrap(value): java.lang.String)
      )(_.configArn)
      .optionallyWith(configId.map(value => value: java.lang.String))(
        _.configId
      )
      .optionallyWith(configType.map(value => value.unwrap))(_.configType)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ConfigListItem.ReadOnly =
    zio.aws.groundstation.model.ConfigListItem.wrap(buildAwsValue())
}
object ConfigListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ConfigListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ConfigListItem =
      zio.aws.groundstation.model.ConfigListItem(
        configArn.map(value => value),
        configId.map(value => value),
        configType.map(value => value),
        name.map(value => value)
      )
    def configArn: Optional[ConfigArn]
    def configId: Optional[String]
    def configType: Optional[zio.aws.groundstation.model.ConfigCapabilityType]
    def name: Optional[String]
    def getConfigArn: ZIO[Any, AwsError, ConfigArn] =
      AwsError.unwrapOptionField("configArn", configArn)
    def getConfigId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configId", configId)
    def getConfigType
        : ZIO[Any, AwsError, zio.aws.groundstation.model.ConfigCapabilityType] =
      AwsError.unwrapOptionField("configType", configType)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ConfigListItem
  ) extends zio.aws.groundstation.model.ConfigListItem.ReadOnly {
    override val configArn: Optional[ConfigArn] = zio.aws.core.internal
      .optionalFromNullable(impl.configArn())
      .map(value => zio.aws.groundstation.model.primitives.ConfigArn(value))
    override val configId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configId())
      .map(value => value: String)
    override val configType
        : Optional[zio.aws.groundstation.model.ConfigCapabilityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configType())
        .map(value =>
          zio.aws.groundstation.model.ConfigCapabilityType.wrap(value)
        )
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ConfigListItem
  ): zio.aws.groundstation.model.ConfigListItem.ReadOnly = new Wrapper(impl)
}
