package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.{
  VersionString,
  ComponentTypeString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ComponentVersion(
    componentType: ComponentTypeString,
    versions: Iterable[VersionString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ComponentVersion = {
    import ComponentVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ComponentVersion
      .builder()
      .componentType(
        ComponentTypeString.unwrap(componentType): java.lang.String
      )
      .versions(versions.map { item =>
        VersionString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ComponentVersion.ReadOnly =
    zio.aws.groundstation.model.ComponentVersion.wrap(buildAwsValue())
}
object ComponentVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ComponentVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ComponentVersion =
      zio.aws.groundstation.model.ComponentVersion(componentType, versions)
    def componentType: ComponentTypeString
    def versions: List[VersionString]
    def getComponentType: ZIO[Any, Nothing, ComponentTypeString] =
      ZIO.succeed(componentType)
    def getVersions: ZIO[Any, Nothing, List[VersionString]] =
      ZIO.succeed(versions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ComponentVersion
  ) extends zio.aws.groundstation.model.ComponentVersion.ReadOnly {
    override val componentType: ComponentTypeString =
      zio.aws.groundstation.model.primitives
        .ComponentTypeString(impl.componentType())
    override val versions: List[VersionString] = impl
      .versions()
      .asScala
      .map { item =>
        zio.aws.groundstation.model.primitives.VersionString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ComponentVersion
  ): zio.aws.groundstation.model.ComponentVersion.ReadOnly = new Wrapper(impl)
}
