package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.{
  Uuid,
  ComponentTypeString,
  CapabilityArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComponentStatusData(
    bytesReceived: Optional[Long] = Optional.Absent,
    bytesSent: Optional[Long] = Optional.Absent,
    capabilityArn: CapabilityArn,
    componentType: ComponentTypeString,
    dataflowId: Uuid,
    packetsDropped: Optional[Long] = Optional.Absent,
    status: zio.aws.groundstation.model.AgentStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ComponentStatusData = {
    import ComponentStatusData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ComponentStatusData
      .builder()
      .optionallyWith(bytesReceived.map(value => value: java.lang.Long))(
        _.bytesReceived
      )
      .optionallyWith(bytesSent.map(value => value: java.lang.Long))(
        _.bytesSent
      )
      .capabilityArn(CapabilityArn.unwrap(capabilityArn): java.lang.String)
      .componentType(
        ComponentTypeString.unwrap(componentType): java.lang.String
      )
      .dataflowId(Uuid.unwrap(dataflowId): java.lang.String)
      .optionallyWith(packetsDropped.map(value => value: java.lang.Long))(
        _.packetsDropped
      )
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ComponentStatusData.ReadOnly =
    zio.aws.groundstation.model.ComponentStatusData.wrap(buildAwsValue())
}
object ComponentStatusData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ComponentStatusData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ComponentStatusData =
      zio.aws.groundstation.model.ComponentStatusData(
        bytesReceived.map(value => value),
        bytesSent.map(value => value),
        capabilityArn,
        componentType,
        dataflowId,
        packetsDropped.map(value => value),
        status
      )
    def bytesReceived: Optional[Long]
    def bytesSent: Optional[Long]
    def capabilityArn: CapabilityArn
    def componentType: ComponentTypeString
    def dataflowId: Uuid
    def packetsDropped: Optional[Long]
    def status: zio.aws.groundstation.model.AgentStatus
    def getBytesReceived: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesReceived", bytesReceived)
    def getBytesSent: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesSent", bytesSent)
    def getCapabilityArn: ZIO[Any, Nothing, CapabilityArn] =
      ZIO.succeed(capabilityArn)
    def getComponentType: ZIO[Any, Nothing, ComponentTypeString] =
      ZIO.succeed(componentType)
    def getDataflowId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(dataflowId)
    def getPacketsDropped: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("packetsDropped", packetsDropped)
    def getStatus: ZIO[Any, Nothing, zio.aws.groundstation.model.AgentStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ComponentStatusData
  ) extends zio.aws.groundstation.model.ComponentStatusData.ReadOnly {
    override val bytesReceived: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.bytesReceived())
      .map(value => value: Long)
    override val bytesSent: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.bytesSent())
      .map(value => value: Long)
    override val capabilityArn: CapabilityArn =
      zio.aws.groundstation.model.primitives.CapabilityArn(impl.capabilityArn())
    override val componentType: ComponentTypeString =
      zio.aws.groundstation.model.primitives
        .ComponentTypeString(impl.componentType())
    override val dataflowId: Uuid =
      zio.aws.groundstation.model.primitives.Uuid(impl.dataflowId())
    override val packetsDropped: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.packetsDropped())
      .map(value => value: Long)
    override val status: zio.aws.groundstation.model.AgentStatus =
      zio.aws.groundstation.model.AgentStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ComponentStatusData
  ): zio.aws.groundstation.model.ComponentStatusData.ReadOnly = new Wrapper(
    impl
  )
}
