package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.SafeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsGroundStationAgentEndpoint(
    agentStatus: Optional[zio.aws.groundstation.model.AgentStatus] =
      Optional.Absent,
    auditResults: Optional[zio.aws.groundstation.model.AuditResults] =
      Optional.Absent,
    egressAddress: zio.aws.groundstation.model.ConnectionDetails,
    ingressAddress: zio.aws.groundstation.model.RangedConnectionDetails,
    name: SafeName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.AwsGroundStationAgentEndpoint = {
    import AwsGroundStationAgentEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.AwsGroundStationAgentEndpoint
      .builder()
      .optionallyWith(agentStatus.map(value => value.unwrap))(_.agentStatus)
      .optionallyWith(auditResults.map(value => value.unwrap))(_.auditResults)
      .egressAddress(egressAddress.buildAwsValue())
      .ingressAddress(ingressAddress.buildAwsValue())
      .name(SafeName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.AwsGroundStationAgentEndpoint.ReadOnly =
    zio.aws.groundstation.model.AwsGroundStationAgentEndpoint
      .wrap(buildAwsValue())
}
object AwsGroundStationAgentEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.AwsGroundStationAgentEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.AwsGroundStationAgentEndpoint =
      zio.aws.groundstation.model.AwsGroundStationAgentEndpoint(
        agentStatus.map(value => value),
        auditResults.map(value => value),
        egressAddress.asEditable,
        ingressAddress.asEditable,
        name
      )
    def agentStatus: Optional[zio.aws.groundstation.model.AgentStatus]
    def auditResults: Optional[zio.aws.groundstation.model.AuditResults]
    def egressAddress: zio.aws.groundstation.model.ConnectionDetails.ReadOnly
    def ingressAddress
        : zio.aws.groundstation.model.RangedConnectionDetails.ReadOnly
    def name: SafeName
    def getAgentStatus
        : ZIO[Any, AwsError, zio.aws.groundstation.model.AgentStatus] =
      AwsError.unwrapOptionField("agentStatus", agentStatus)
    def getAuditResults
        : ZIO[Any, AwsError, zio.aws.groundstation.model.AuditResults] =
      AwsError.unwrapOptionField("auditResults", auditResults)
    def getEgressAddress: ZIO[
      Any,
      Nothing,
      zio.aws.groundstation.model.ConnectionDetails.ReadOnly
    ] = ZIO.succeed(egressAddress)
    def getIngressAddress: ZIO[
      Any,
      Nothing,
      zio.aws.groundstation.model.RangedConnectionDetails.ReadOnly
    ] = ZIO.succeed(ingressAddress)
    def getName: ZIO[Any, Nothing, SafeName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.AwsGroundStationAgentEndpoint
  ) extends zio.aws.groundstation.model.AwsGroundStationAgentEndpoint.ReadOnly {
    override val agentStatus
        : Optional[zio.aws.groundstation.model.AgentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.agentStatus())
        .map(value => zio.aws.groundstation.model.AgentStatus.wrap(value))
    override val auditResults
        : Optional[zio.aws.groundstation.model.AuditResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auditResults())
        .map(value => zio.aws.groundstation.model.AuditResults.wrap(value))
    override val egressAddress
        : zio.aws.groundstation.model.ConnectionDetails.ReadOnly =
      zio.aws.groundstation.model.ConnectionDetails.wrap(impl.egressAddress())
    override val ingressAddress
        : zio.aws.groundstation.model.RangedConnectionDetails.ReadOnly =
      zio.aws.groundstation.model.RangedConnectionDetails
        .wrap(impl.ingressAddress())
    override val name: SafeName =
      zio.aws.groundstation.model.primitives.SafeName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.AwsGroundStationAgentEndpoint
  ): zio.aws.groundstation.model.AwsGroundStationAgentEndpoint.ReadOnly =
    new Wrapper(impl)
}
