package zio.aws.groundstation.model
import scala.jdk.CollectionConverters._
sealed trait AuditResults {
  def unwrap: software.amazon.awssdk.services.groundstation.model.AuditResults
}
object AuditResults {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.AuditResults
  ): zio.aws.groundstation.model.AuditResults = value match {
    case software.amazon.awssdk.services.groundstation.model.AuditResults.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.AuditResults.HEALTHY =>
      val r = HEALTHY
      r
    case software.amazon.awssdk.services.groundstation.model.AuditResults.UNHEALTHY =>
      val r = UNHEALTHY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.AuditResults {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.AuditResults =
      software.amazon.awssdk.services.groundstation.model.AuditResults.UNKNOWN_TO_SDK_VERSION
  }
  case object HEALTHY extends zio.aws.groundstation.model.AuditResults {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.AuditResults =
      software.amazon.awssdk.services.groundstation.model.AuditResults.HEALTHY
  }
  case object UNHEALTHY extends zio.aws.groundstation.model.AuditResults {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.AuditResults =
      software.amazon.awssdk.services.groundstation.model.AuditResults.UNHEALTHY
  }
}
