package zio.aws.groundstation.model
import scala.jdk.CollectionConverters._
sealed trait AngleUnits {
  def unwrap: software.amazon.awssdk.services.groundstation.model.AngleUnits
}
object AngleUnits {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.AngleUnits
  ): zio.aws.groundstation.model.AngleUnits = value match {
    case software.amazon.awssdk.services.groundstation.model.AngleUnits.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.AngleUnits.DEGREE_ANGLE =>
      val r = DEGREE_ANGLE
      r
    case software.amazon.awssdk.services.groundstation.model.AngleUnits.RADIAN =>
      val r = RADIAN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.AngleUnits {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.AngleUnits =
      software.amazon.awssdk.services.groundstation.model.AngleUnits.UNKNOWN_TO_SDK_VERSION
  }
  case object DEGREE_ANGLE extends zio.aws.groundstation.model.AngleUnits {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.AngleUnits =
      software.amazon.awssdk.services.groundstation.model.AngleUnits.DEGREE_ANGLE
  }
  case object RADIAN extends zio.aws.groundstation.model.AngleUnits {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.AngleUnits =
      software.amazon.awssdk.services.groundstation.model.AngleUnits.RADIAN
  }
}
