package zio.aws.groundstation
import zio.aws.groundstation.model.primitives.{
  UnboundedString,
  VersionString,
  Integer,
  CapabilityArn,
  GroundStationName,
  IpV4Address,
  ConfigArn
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.groundstation.model.primitives.TleLineOne.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AWSRegion extends Subtype[String]
    type AWSRegion = zio.aws.groundstation.model.primitives.AWSRegion.Type
    object AnyArn extends Subtype[String]
    type AnyArn = zio.aws.groundstation.model.primitives.AnyArn.Type
    object BucketArn extends Subtype[String]
    type BucketArn = zio.aws.groundstation.model.primitives.BucketArn.Type
    object CapabilityArn extends Subtype[String]
    type CapabilityArn =
      zio.aws.groundstation.model.primitives.CapabilityArn.Type
    object ConfigArn extends Subtype[String]
    type ConfigArn = zio.aws.groundstation.model.primitives.ConfigArn.Type
    object CustomerEphemerisPriority extends Subtype[Int]
    type CustomerEphemerisPriority =
      zio.aws.groundstation.model.primitives.CustomerEphemerisPriority.Type
    object DataflowEndpointGroupArn extends Subtype[String]
    type DataflowEndpointGroupArn =
      zio.aws.groundstation.model.primitives.DataflowEndpointGroupArn.Type
    object DataflowEndpointGroupDurationInSeconds extends Subtype[Int]
    type DataflowEndpointGroupDurationInSeconds =
      zio.aws.groundstation.model.primitives.DataflowEndpointGroupDurationInSeconds.Type
    object DataflowEndpointMtuInteger extends Subtype[Int]
    type DataflowEndpointMtuInteger =
      zio.aws.groundstation.model.primitives.DataflowEndpointMtuInteger.Type
    object DurationInSeconds extends Subtype[Int]
    type DurationInSeconds =
      zio.aws.groundstation.model.primitives.DurationInSeconds.Type
    object EphemerisPriority extends Subtype[Int]
    type EphemerisPriority =
      zio.aws.groundstation.model.primitives.EphemerisPriority.Type
    object GroundStationName extends Subtype[String]
    type GroundStationName =
      zio.aws.groundstation.model.primitives.GroundStationName.Type
    object InstanceId extends Subtype[String]
    type InstanceId = zio.aws.groundstation.model.primitives.InstanceId.Type
    object InstanceType extends Subtype[String]
    type InstanceType = zio.aws.groundstation.model.primitives.InstanceType.Type
    type Integer = Int
    object IpV4Address extends Subtype[String]
    type IpV4Address = zio.aws.groundstation.model.primitives.IpV4Address.Type
    object JsonString extends Subtype[String]
    type JsonString = zio.aws.groundstation.model.primitives.JsonString.Type
    object KeyAliasArn extends Subtype[String]
    type KeyAliasArn = zio.aws.groundstation.model.primitives.KeyAliasArn.Type
    object KeyArn extends Subtype[String]
    type KeyArn = zio.aws.groundstation.model.primitives.KeyArn.Type
    object MissionProfileArn extends Subtype[String]
    type MissionProfileArn =
      zio.aws.groundstation.model.primitives.MissionProfileArn.Type
    object Month extends Subtype[Int]
    type Month = zio.aws.groundstation.model.primitives.Month.Type
    object NoradSatelliteID extends Subtype[Int]
    type NoradSatelliteID =
      zio.aws.groundstation.model.primitives.NoradSatelliteID.Type
    object PaginationMaxResults extends Subtype[Int]
    type PaginationMaxResults =
      zio.aws.groundstation.model.primitives.PaginationMaxResults.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.groundstation.model.primitives.PaginationToken.Type
    object PositiveDurationInSeconds extends Subtype[Int]
    type PositiveDurationInSeconds =
      zio.aws.groundstation.model.primitives.PositiveDurationInSeconds.Type
    object RangedConnectionDetailsMtuInteger extends Subtype[Int]
    type RangedConnectionDetailsMtuInteger =
      zio.aws.groundstation.model.primitives.RangedConnectionDetailsMtuInteger.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.groundstation.model.primitives.RoleArn.Type
    object S3BucketName extends Subtype[String]
    type S3BucketName = zio.aws.groundstation.model.primitives.S3BucketName.Type
    object S3KeyPrefix extends Subtype[String]
    type S3KeyPrefix = zio.aws.groundstation.model.primitives.S3KeyPrefix.Type
    object S3ObjectKey extends Subtype[String]
    type S3ObjectKey = zio.aws.groundstation.model.primitives.S3ObjectKey.Type
    object S3VersionId extends Subtype[String]
    type S3VersionId = zio.aws.groundstation.model.primitives.S3VersionId.Type
    object SafeName extends Subtype[String]
    type SafeName = zio.aws.groundstation.model.primitives.SafeName.Type
    object SatelliteArn extends Subtype[String]
    type SatelliteArn = zio.aws.groundstation.model.primitives.SatelliteArn.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.groundstation.model.primitives.Timestamp.Type
    object TleLineOne extends Subtype[String]
    type TleLineOne = zio.aws.groundstation.model.primitives.TleLineOne.Type
    object TleLineTwo extends Subtype[String]
    type TleLineTwo = zio.aws.groundstation.model.primitives.TleLineTwo.Type
    object UnboundedString extends Subtype[String]
    type UnboundedString =
      zio.aws.groundstation.model.primitives.UnboundedString.Type
    object Uuid extends Subtype[String]
    type Uuid = zio.aws.groundstation.model.primitives.Uuid.Type
    object VersionString extends Subtype[String]
    type VersionString =
      zio.aws.groundstation.model.primitives.VersionString.Type
    object Year extends Subtype[Int]
    type Year = zio.aws.groundstation.model.primitives.Year.Type
  }
  type CapabilityArnList = List[CapabilityArn]
  type ComponentStatusList =
    List[zio.aws.groundstation.model.ComponentStatusData]
  type ComponentVersionList = List[zio.aws.groundstation.model.ComponentVersion]
  type ConfigList = List[zio.aws.groundstation.model.ConfigListItem]
  type ContactList = List[zio.aws.groundstation.model.ContactData]
  type DataflowEdge = List[ConfigArn]
  type DataflowEdgeList = List[Iterable[ConfigArn]]
  type DataflowEndpointGroupList =
    List[zio.aws.groundstation.model.DataflowEndpointListItem]
  type DataflowList = List[zio.aws.groundstation.model.DataflowDetail]
  type EndpointDetailsList = List[zio.aws.groundstation.model.EndpointDetails]
  type EphemeridesList = List[zio.aws.groundstation.model.EphemerisItem]
  type EphemerisStatusList = List[zio.aws.groundstation.model.EphemerisStatus]
  type GroundStationIdList = List[GroundStationName]
  type GroundStationList = List[zio.aws.groundstation.model.GroundStationData]
  type IpAddressList = List[IpV4Address]
  type MissionProfileList =
    List[zio.aws.groundstation.model.MissionProfileListItem]
  type ReservedCpuCoresList = List[Integer]
  type SatelliteList = List[zio.aws.groundstation.model.SatelliteListItem]
  type SecurityGroupIdList = List[String]
  type SignatureMap = Map[String, Boolean]
  type StatusList = List[zio.aws.groundstation.model.ContactStatus]
  type SubnetList = List[String]
  type TLEDataList = List[zio.aws.groundstation.model.TLEData]
  type TagKeys = List[UnboundedString]
  type TagsMap = Map[String, String]
  type VersionStringList = List[VersionString]
}
