package zio.aws.groundstation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{
  EphemerisPriority,
  SafeName,
  Uuid
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateEphemerisRequest(
    enabled: Boolean,
    ephemerisId: Uuid,
    name: Optional[SafeName] = Optional.Absent,
    priority: Optional[EphemerisPriority] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.UpdateEphemerisRequest = {
    import UpdateEphemerisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.UpdateEphemerisRequest
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .ephemerisId(Uuid.unwrap(ephemerisId): java.lang.String)
      .optionallyWith(
        name.map(value => SafeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        priority.map(value => EphemerisPriority.unwrap(value): Integer)
      )(_.priority)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.UpdateEphemerisRequest.ReadOnly =
    zio.aws.groundstation.model.UpdateEphemerisRequest.wrap(buildAwsValue())
}
object UpdateEphemerisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.UpdateEphemerisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.UpdateEphemerisRequest =
      zio.aws.groundstation.model.UpdateEphemerisRequest(
        enabled,
        ephemerisId,
        name.map(value => value),
        priority.map(value => value)
      )
    def enabled: Boolean
    def ephemerisId: Uuid
    def name: Optional[SafeName]
    def priority: Optional[EphemerisPriority]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getEphemerisId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(ephemerisId)
    def getName: ZIO[Any, AwsError, SafeName] =
      AwsError.unwrapOptionField("name", name)
    def getPriority: ZIO[Any, AwsError, EphemerisPriority] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateEphemerisRequest
  ) extends zio.aws.groundstation.model.UpdateEphemerisRequest.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val ephemerisId: Uuid =
      zio.aws.groundstation.model.primitives.Uuid(impl.ephemerisId())
    override val name: Optional[SafeName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.groundstation.model.primitives.SafeName(value))
    override val priority: Optional[EphemerisPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value =>
        zio.aws.groundstation.model.primitives.EphemerisPriority(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateEphemerisRequest
  ): zio.aws.groundstation.model.UpdateEphemerisRequest.ReadOnly = new Wrapper(
    impl
  )
}
