package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateAgentStatusResponse(agentId: Uuid) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusResponse = {
    import UpdateAgentStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusResponse
      .builder()
      .agentId(Uuid.unwrap(agentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.UpdateAgentStatusResponse.ReadOnly =
    zio.aws.groundstation.model.UpdateAgentStatusResponse.wrap(buildAwsValue())
}
object UpdateAgentStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.UpdateAgentStatusResponse =
      zio.aws.groundstation.model.UpdateAgentStatusResponse(agentId)
    def agentId: Uuid
    def getAgentId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(agentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusResponse
  ) extends zio.aws.groundstation.model.UpdateAgentStatusResponse.ReadOnly {
    override val agentId: Uuid =
      zio.aws.groundstation.model.primitives.Uuid(impl.agentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusResponse
  ): zio.aws.groundstation.model.UpdateAgentStatusResponse.ReadOnly =
    new Wrapper(impl)
}
