package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.AnyArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: AnyArn,
    tags: Map[String, String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.TagResourceRequest
      .builder()
      .resourceArn(AnyArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.TagResourceRequest.ReadOnly =
    zio.aws.groundstation.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.TagResourceRequest =
      zio.aws.groundstation.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: AnyArn
    def tags: Map[String, String]
    def getResourceArn: ZIO[Any, Nothing, AnyArn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[String, String]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.TagResourceRequest
  ) extends zio.aws.groundstation.model.TagResourceRequest.ReadOnly {
    override val resourceArn: AnyArn =
      zio.aws.groundstation.model.primitives.AnyArn(impl.resourceArn())
    override val tags: Map[String, String] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> (value: String)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.TagResourceRequest
  ): zio.aws.groundstation.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
