package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TLEEphemeris(
    s3Object: Optional[zio.aws.groundstation.model.S3Object] = Optional.Absent,
    tleData: Optional[Iterable[zio.aws.groundstation.model.TLEData]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.TLEEphemeris = {
    import TLEEphemeris.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.TLEEphemeris
      .builder()
      .optionallyWith(s3Object.map(value => value.buildAwsValue()))(_.s3Object)
      .optionallyWith(
        tleData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tleData)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.TLEEphemeris.ReadOnly =
    zio.aws.groundstation.model.TLEEphemeris.wrap(buildAwsValue())
}
object TLEEphemeris {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.TLEEphemeris
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.TLEEphemeris =
      zio.aws.groundstation.model.TLEEphemeris(
        s3Object.map(value => value.asEditable),
        tleData.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def s3Object: Optional[zio.aws.groundstation.model.S3Object.ReadOnly]
    def tleData: Optional[List[zio.aws.groundstation.model.TLEData.ReadOnly]]
    def getS3Object
        : ZIO[Any, AwsError, zio.aws.groundstation.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("s3Object", s3Object)
    def getTleData: ZIO[Any, AwsError, List[
      zio.aws.groundstation.model.TLEData.ReadOnly
    ]] = AwsError.unwrapOptionField("tleData", tleData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.TLEEphemeris
  ) extends zio.aws.groundstation.model.TLEEphemeris.ReadOnly {
    override val s3Object
        : Optional[zio.aws.groundstation.model.S3Object.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Object())
        .map(value => zio.aws.groundstation.model.S3Object.wrap(value))
    override val tleData
        : Optional[List[zio.aws.groundstation.model.TLEData.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tleData())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.groundstation.model.TLEData.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.TLEEphemeris
  ): zio.aws.groundstation.model.TLEEphemeris.ReadOnly = new Wrapper(impl)
}
