package zio.aws.groundstation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{
  Uuid,
  SatelliteArn,
  NoradSatelliteID,
  GroundStationName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SatelliteListItem(
    currentEphemeris: Optional[zio.aws.groundstation.model.EphemerisMetaData] =
      Optional.Absent,
    groundStations: Optional[Iterable[GroundStationName]] = Optional.Absent,
    noradSatelliteID: Optional[NoradSatelliteID] = Optional.Absent,
    satelliteArn: Optional[SatelliteArn] = Optional.Absent,
    satelliteId: Optional[Uuid] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.SatelliteListItem = {
    import SatelliteListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.SatelliteListItem
      .builder()
      .optionallyWith(currentEphemeris.map(value => value.buildAwsValue()))(
        _.currentEphemeris
      )
      .optionallyWith(
        groundStations.map(value =>
          value.map { item =>
            GroundStationName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groundStations)
      .optionallyWith(
        noradSatelliteID.map(value => NoradSatelliteID.unwrap(value): Integer)
      )(_.noradSatelliteID)
      .optionallyWith(
        satelliteArn.map(value => SatelliteArn.unwrap(value): java.lang.String)
      )(_.satelliteArn)
      .optionallyWith(
        satelliteId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.satelliteId)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.SatelliteListItem.ReadOnly =
    zio.aws.groundstation.model.SatelliteListItem.wrap(buildAwsValue())
}
object SatelliteListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.SatelliteListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.SatelliteListItem =
      zio.aws.groundstation.model.SatelliteListItem(
        currentEphemeris.map(value => value.asEditable),
        groundStations.map(value => value),
        noradSatelliteID.map(value => value),
        satelliteArn.map(value => value),
        satelliteId.map(value => value)
      )
    def currentEphemeris
        : Optional[zio.aws.groundstation.model.EphemerisMetaData.ReadOnly]
    def groundStations: Optional[List[GroundStationName]]
    def noradSatelliteID: Optional[NoradSatelliteID]
    def satelliteArn: Optional[SatelliteArn]
    def satelliteId: Optional[Uuid]
    def getCurrentEphemeris: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.EphemerisMetaData.ReadOnly
    ] = AwsError.unwrapOptionField("currentEphemeris", currentEphemeris)
    def getGroundStations: ZIO[Any, AwsError, List[GroundStationName]] =
      AwsError.unwrapOptionField("groundStations", groundStations)
    def getNoradSatelliteID: ZIO[Any, AwsError, NoradSatelliteID] =
      AwsError.unwrapOptionField("noradSatelliteID", noradSatelliteID)
    def getSatelliteArn: ZIO[Any, AwsError, SatelliteArn] =
      AwsError.unwrapOptionField("satelliteArn", satelliteArn)
    def getSatelliteId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("satelliteId", satelliteId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.SatelliteListItem
  ) extends zio.aws.groundstation.model.SatelliteListItem.ReadOnly {
    override val currentEphemeris
        : Optional[zio.aws.groundstation.model.EphemerisMetaData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentEphemeris())
        .map(value => zio.aws.groundstation.model.EphemerisMetaData.wrap(value))
    override val groundStations: Optional[List[GroundStationName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groundStations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.groundstation.model.primitives.GroundStationName(item)
          }.toList
        )
    override val noradSatelliteID: Optional[NoradSatelliteID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noradSatelliteID())
        .map(value =>
          zio.aws.groundstation.model.primitives.NoradSatelliteID(value)
        )
    override val satelliteArn: Optional[SatelliteArn] = zio.aws.core.internal
      .optionalFromNullable(impl.satelliteArn())
      .map(value => zio.aws.groundstation.model.primitives.SatelliteArn(value))
    override val satelliteId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.satelliteId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.SatelliteListItem
  ): zio.aws.groundstation.model.SatelliteListItem.ReadOnly = new Wrapper(impl)
}
