package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.{
  AWSRegion,
  SafeName,
  Uuid,
  MissionProfileArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MissionProfileListItem(
    missionProfileArn: Optional[MissionProfileArn] = Optional.Absent,
    missionProfileId: Optional[Uuid] = Optional.Absent,
    name: Optional[SafeName] = Optional.Absent,
    region: Optional[AWSRegion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.MissionProfileListItem = {
    import MissionProfileListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.MissionProfileListItem
      .builder()
      .optionallyWith(
        missionProfileArn.map(value =>
          MissionProfileArn.unwrap(value): java.lang.String
        )
      )(_.missionProfileArn)
      .optionallyWith(
        missionProfileId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.missionProfileId)
      .optionallyWith(
        name.map(value => SafeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        region.map(value => AWSRegion.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.MissionProfileListItem.ReadOnly =
    zio.aws.groundstation.model.MissionProfileListItem.wrap(buildAwsValue())
}
object MissionProfileListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.MissionProfileListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.MissionProfileListItem =
      zio.aws.groundstation.model.MissionProfileListItem(
        missionProfileArn.map(value => value),
        missionProfileId.map(value => value),
        name.map(value => value),
        region.map(value => value)
      )
    def missionProfileArn: Optional[MissionProfileArn]
    def missionProfileId: Optional[Uuid]
    def name: Optional[SafeName]
    def region: Optional[AWSRegion]
    def getMissionProfileArn: ZIO[Any, AwsError, MissionProfileArn] =
      AwsError.unwrapOptionField("missionProfileArn", missionProfileArn)
    def getMissionProfileId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("missionProfileId", missionProfileId)
    def getName: ZIO[Any, AwsError, SafeName] =
      AwsError.unwrapOptionField("name", name)
    def getRegion: ZIO[Any, AwsError, AWSRegion] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.MissionProfileListItem
  ) extends zio.aws.groundstation.model.MissionProfileListItem.ReadOnly {
    override val missionProfileArn: Optional[MissionProfileArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.missionProfileArn())
        .map(value =>
          zio.aws.groundstation.model.primitives.MissionProfileArn(value)
        )
    override val missionProfileId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.missionProfileId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
    override val name: Optional[SafeName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.groundstation.model.primitives.SafeName(value))
    override val region: Optional[AWSRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.groundstation.model.primitives.AWSRegion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.MissionProfileListItem
  ): zio.aws.groundstation.model.MissionProfileListItem.ReadOnly = new Wrapper(
    impl
  )
}
