package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListGroundStationsResponse(
    groundStationList: Optional[
      Iterable[zio.aws.groundstation.model.GroundStationData]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse = {
    import ListGroundStationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse
      .builder()
      .optionallyWith(
        groundStationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groundStationList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.ListGroundStationsResponse.ReadOnly =
    zio.aws.groundstation.model.ListGroundStationsResponse.wrap(buildAwsValue())
}
object ListGroundStationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ListGroundStationsResponse =
      zio.aws.groundstation.model.ListGroundStationsResponse(
        groundStationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def groundStationList
        : Optional[List[zio.aws.groundstation.model.GroundStationData.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getGroundStationList: ZIO[Any, AwsError, List[
      zio.aws.groundstation.model.GroundStationData.ReadOnly
    ]] = AwsError.unwrapOptionField("groundStationList", groundStationList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse
  ) extends zio.aws.groundstation.model.ListGroundStationsResponse.ReadOnly {
    override val groundStationList: Optional[
      List[zio.aws.groundstation.model.GroundStationData.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.groundStationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.groundstation.model.GroundStationData.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.groundstation.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse
  ): zio.aws.groundstation.model.ListGroundStationsResponse.ReadOnly =
    new Wrapper(impl)
}
