package zio.aws.groundstation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{
  Uuid,
  PaginationToken,
  PaginationMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListGroundStationsRequest(
    maxResults: Optional[PaginationMaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    satelliteId: Optional[Uuid] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest = {
    import ListGroundStationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => PaginationMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        satelliteId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.satelliteId)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.ListGroundStationsRequest.ReadOnly =
    zio.aws.groundstation.model.ListGroundStationsRequest.wrap(buildAwsValue())
}
object ListGroundStationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ListGroundStationsRequest =
      zio.aws.groundstation.model.ListGroundStationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        satelliteId.map(value => value)
      )
    def maxResults: Optional[PaginationMaxResults]
    def nextToken: Optional[PaginationToken]
    def satelliteId: Optional[Uuid]
    def getMaxResults: ZIO[Any, AwsError, PaginationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSatelliteId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("satelliteId", satelliteId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest
  ) extends zio.aws.groundstation.model.ListGroundStationsRequest.ReadOnly {
    override val maxResults: Optional[PaginationMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.groundstation.model.primitives.PaginationMaxResults(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.groundstation.model.primitives.PaginationToken(value)
      )
    override val satelliteId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.satelliteId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest
  ): zio.aws.groundstation.model.ListGroundStationsRequest.ReadOnly =
    new Wrapper(impl)
}
