package zio.aws.groundstation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{
  RoleArn,
  SafeName,
  DurationInSeconds,
  AWSRegion,
  Uuid,
  MissionProfileArn,
  PositiveDurationInSeconds,
  ConfigArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetMissionProfileResponse(
    contactPostPassDurationSeconds: Optional[DurationInSeconds] =
      Optional.Absent,
    contactPrePassDurationSeconds: Optional[DurationInSeconds] =
      Optional.Absent,
    dataflowEdges: Optional[Iterable[Iterable[ConfigArn]]] = Optional.Absent,
    minimumViableContactDurationSeconds: Optional[PositiveDurationInSeconds] =
      Optional.Absent,
    missionProfileArn: Optional[MissionProfileArn] = Optional.Absent,
    missionProfileId: Optional[Uuid] = Optional.Absent,
    name: Optional[SafeName] = Optional.Absent,
    region: Optional[AWSRegion] = Optional.Absent,
    streamsKmsKey: Optional[zio.aws.groundstation.model.KmsKey] =
      Optional.Absent,
    streamsKmsRole: Optional[RoleArn] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    trackingConfigArn: Optional[ConfigArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GetMissionProfileResponse = {
    import GetMissionProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GetMissionProfileResponse
      .builder()
      .optionallyWith(
        contactPostPassDurationSeconds.map(value =>
          DurationInSeconds.unwrap(value): Integer
        )
      )(_.contactPostPassDurationSeconds)
      .optionallyWith(
        contactPrePassDurationSeconds.map(value =>
          DurationInSeconds.unwrap(value): Integer
        )
      )(_.contactPrePassDurationSeconds)
      .optionallyWith(
        dataflowEdges.map(value =>
          value.map { item =>
            item.map { item =>
              ConfigArn.unwrap(item): java.lang.String
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.dataflowEdges)
      .optionallyWith(
        minimumViableContactDurationSeconds.map(value =>
          PositiveDurationInSeconds.unwrap(value): Integer
        )
      )(_.minimumViableContactDurationSeconds)
      .optionallyWith(
        missionProfileArn.map(value =>
          MissionProfileArn.unwrap(value): java.lang.String
        )
      )(_.missionProfileArn)
      .optionallyWith(
        missionProfileId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.missionProfileId)
      .optionallyWith(
        name.map(value => SafeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        region.map(value => AWSRegion.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(streamsKmsKey.map(value => value.buildAwsValue()))(
        _.streamsKmsKey
      )
      .optionallyWith(
        streamsKmsRole.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.streamsKmsRole)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        trackingConfigArn.map(value =>
          ConfigArn.unwrap(value): java.lang.String
        )
      )(_.trackingConfigArn)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.GetMissionProfileResponse.ReadOnly =
    zio.aws.groundstation.model.GetMissionProfileResponse.wrap(buildAwsValue())
}
object GetMissionProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GetMissionProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.GetMissionProfileResponse =
      zio.aws.groundstation.model.GetMissionProfileResponse(
        contactPostPassDurationSeconds.map(value => value),
        contactPrePassDurationSeconds.map(value => value),
        dataflowEdges.map(value => value),
        minimumViableContactDurationSeconds.map(value => value),
        missionProfileArn.map(value => value),
        missionProfileId.map(value => value),
        name.map(value => value),
        region.map(value => value),
        streamsKmsKey.map(value => value.asEditable),
        streamsKmsRole.map(value => value),
        tags.map(value => value),
        trackingConfigArn.map(value => value)
      )
    def contactPostPassDurationSeconds: Optional[DurationInSeconds]
    def contactPrePassDurationSeconds: Optional[DurationInSeconds]
    def dataflowEdges: Optional[List[List[ConfigArn]]]
    def minimumViableContactDurationSeconds: Optional[PositiveDurationInSeconds]
    def missionProfileArn: Optional[MissionProfileArn]
    def missionProfileId: Optional[Uuid]
    def name: Optional[SafeName]
    def region: Optional[AWSRegion]
    def streamsKmsKey: Optional[zio.aws.groundstation.model.KmsKey.ReadOnly]
    def streamsKmsRole: Optional[RoleArn]
    def tags: Optional[Map[String, String]]
    def trackingConfigArn: Optional[ConfigArn]
    def getContactPostPassDurationSeconds
        : ZIO[Any, AwsError, DurationInSeconds] = AwsError.unwrapOptionField(
      "contactPostPassDurationSeconds",
      contactPostPassDurationSeconds
    )
    def getContactPrePassDurationSeconds
        : ZIO[Any, AwsError, DurationInSeconds] = AwsError.unwrapOptionField(
      "contactPrePassDurationSeconds",
      contactPrePassDurationSeconds
    )
    def getDataflowEdges: ZIO[Any, AwsError, List[List[ConfigArn]]] =
      AwsError.unwrapOptionField("dataflowEdges", dataflowEdges)
    def getMinimumViableContactDurationSeconds
        : ZIO[Any, AwsError, PositiveDurationInSeconds] =
      AwsError.unwrapOptionField(
        "minimumViableContactDurationSeconds",
        minimumViableContactDurationSeconds
      )
    def getMissionProfileArn: ZIO[Any, AwsError, MissionProfileArn] =
      AwsError.unwrapOptionField("missionProfileArn", missionProfileArn)
    def getMissionProfileId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("missionProfileId", missionProfileId)
    def getName: ZIO[Any, AwsError, SafeName] =
      AwsError.unwrapOptionField("name", name)
    def getRegion: ZIO[Any, AwsError, AWSRegion] =
      AwsError.unwrapOptionField("region", region)
    def getStreamsKmsKey
        : ZIO[Any, AwsError, zio.aws.groundstation.model.KmsKey.ReadOnly] =
      AwsError.unwrapOptionField("streamsKmsKey", streamsKmsKey)
    def getStreamsKmsRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("streamsKmsRole", streamsKmsRole)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTrackingConfigArn: ZIO[Any, AwsError, ConfigArn] =
      AwsError.unwrapOptionField("trackingConfigArn", trackingConfigArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GetMissionProfileResponse
  ) extends zio.aws.groundstation.model.GetMissionProfileResponse.ReadOnly {
    override val contactPostPassDurationSeconds: Optional[DurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactPostPassDurationSeconds())
        .map(value =>
          zio.aws.groundstation.model.primitives.DurationInSeconds(value)
        )
    override val contactPrePassDurationSeconds: Optional[DurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactPrePassDurationSeconds())
        .map(value =>
          zio.aws.groundstation.model.primitives.DurationInSeconds(value)
        )
    override val dataflowEdges: Optional[List[List[ConfigArn]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataflowEdges())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              zio.aws.groundstation.model.primitives.ConfigArn(item)
            }.toList
          }.toList
        )
    override val minimumViableContactDurationSeconds
        : Optional[PositiveDurationInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.minimumViableContactDurationSeconds())
      .map(value =>
        zio.aws.groundstation.model.primitives.PositiveDurationInSeconds(value)
      )
    override val missionProfileArn: Optional[MissionProfileArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.missionProfileArn())
        .map(value =>
          zio.aws.groundstation.model.primitives.MissionProfileArn(value)
        )
    override val missionProfileId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.missionProfileId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
    override val name: Optional[SafeName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.groundstation.model.primitives.SafeName(value))
    override val region: Optional[AWSRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.groundstation.model.primitives.AWSRegion(value))
    override val streamsKmsKey
        : Optional[zio.aws.groundstation.model.KmsKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamsKmsKey())
        .map(value => zio.aws.groundstation.model.KmsKey.wrap(value))
    override val streamsKmsRole: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.streamsKmsRole())
      .map(value => zio.aws.groundstation.model.primitives.RoleArn(value))
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val trackingConfigArn: Optional[ConfigArn] = zio.aws.core.internal
      .optionalFromNullable(impl.trackingConfigArn())
      .map(value => zio.aws.groundstation.model.primitives.ConfigArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GetMissionProfileResponse
  ): zio.aws.groundstation.model.GetMissionProfileResponse.ReadOnly =
    new Wrapper(impl)
}
