package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAgentConfigurationResponse(
    agentId: Optional[Uuid] = Optional.Absent,
    taskingDocument: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationResponse = {
    import GetAgentConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationResponse
      .builder()
      .optionallyWith(
        agentId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.agentId)
      .optionallyWith(taskingDocument.map(value => value: java.lang.String))(
        _.taskingDocument
      )
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.GetAgentConfigurationResponse.ReadOnly =
    zio.aws.groundstation.model.GetAgentConfigurationResponse
      .wrap(buildAwsValue())
}
object GetAgentConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.GetAgentConfigurationResponse =
      zio.aws.groundstation.model.GetAgentConfigurationResponse(
        agentId.map(value => value),
        taskingDocument.map(value => value)
      )
    def agentId: Optional[Uuid]
    def taskingDocument: Optional[String]
    def getAgentId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("agentId", agentId)
    def getTaskingDocument: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskingDocument", taskingDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationResponse
  ) extends zio.aws.groundstation.model.GetAgentConfigurationResponse.ReadOnly {
    override val agentId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.agentId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
    override val taskingDocument: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskingDocument())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationResponse
  ): zio.aws.groundstation.model.GetAgentConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
