package zio.aws.groundstation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{
  EphemerisPriority,
  SafeName,
  Uuid,
  Timestamp
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EphemerisItem(
    creationTime: Optional[Timestamp] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent,
    ephemerisId: Optional[Uuid] = Optional.Absent,
    name: Optional[SafeName] = Optional.Absent,
    priority: Optional[EphemerisPriority] = Optional.Absent,
    sourceS3Object: Optional[zio.aws.groundstation.model.S3Object] =
      Optional.Absent,
    status: Optional[zio.aws.groundstation.model.EphemerisStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.EphemerisItem = {
    import EphemerisItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.EphemerisItem
      .builder()
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        ephemerisId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.ephemerisId)
      .optionallyWith(
        name.map(value => SafeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        priority.map(value => EphemerisPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(sourceS3Object.map(value => value.buildAwsValue()))(
        _.sourceS3Object
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.EphemerisItem.ReadOnly =
    zio.aws.groundstation.model.EphemerisItem.wrap(buildAwsValue())
}
object EphemerisItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.EphemerisItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.EphemerisItem =
      zio.aws.groundstation.model.EphemerisItem(
        creationTime.map(value => value),
        enabled.map(value => value),
        ephemerisId.map(value => value),
        name.map(value => value),
        priority.map(value => value),
        sourceS3Object.map(value => value.asEditable),
        status.map(value => value)
      )
    def creationTime: Optional[Timestamp]
    def enabled: Optional[Boolean]
    def ephemerisId: Optional[Uuid]
    def name: Optional[SafeName]
    def priority: Optional[EphemerisPriority]
    def sourceS3Object: Optional[zio.aws.groundstation.model.S3Object.ReadOnly]
    def status: Optional[zio.aws.groundstation.model.EphemerisStatus]
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getEphemerisId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("ephemerisId", ephemerisId)
    def getName: ZIO[Any, AwsError, SafeName] =
      AwsError.unwrapOptionField("name", name)
    def getPriority: ZIO[Any, AwsError, EphemerisPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getSourceS3Object
        : ZIO[Any, AwsError, zio.aws.groundstation.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("sourceS3Object", sourceS3Object)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.groundstation.model.EphemerisStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.EphemerisItem
  ) extends zio.aws.groundstation.model.EphemerisItem.ReadOnly {
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.groundstation.model.primitives.Timestamp(value))
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val ephemerisId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.ephemerisId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
    override val name: Optional[SafeName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.groundstation.model.primitives.SafeName(value))
    override val priority: Optional[EphemerisPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value =>
        zio.aws.groundstation.model.primitives.EphemerisPriority(value)
      )
    override val sourceS3Object
        : Optional[zio.aws.groundstation.model.S3Object.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceS3Object())
        .map(value => zio.aws.groundstation.model.S3Object.wrap(value))
    override val status: Optional[zio.aws.groundstation.model.EphemerisStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.groundstation.model.EphemerisStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.EphemerisItem
  ): zio.aws.groundstation.model.EphemerisItem.ReadOnly = new Wrapper(impl)
}
