package zio.aws.groundstation.model
import scala.jdk.CollectionConverters._
sealed trait EphemerisInvalidReason {
  def unwrap: software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason
}
object EphemerisInvalidReason {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason
  ): zio.aws.groundstation.model.EphemerisInvalidReason = value match {
    case software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason.METADATA_INVALID =>
      val r = METADATA_INVALID
      r
    case software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason.TIME_RANGE_INVALID =>
      val r = TIME_RANGE_INVALID
      r
    case software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason.TRAJECTORY_INVALID =>
      val r = TRAJECTORY_INVALID
      r
    case software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason.KMS_KEY_INVALID =>
      val r = KMS_KEY_INVALID
      r
    case software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason.VALIDATION_ERROR =>
      val r = VALIDATION_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.EphemerisInvalidReason {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason =
      software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason.UNKNOWN_TO_SDK_VERSION
  }
  case object METADATA_INVALID
      extends zio.aws.groundstation.model.EphemerisInvalidReason {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason =
      software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason.METADATA_INVALID
  }
  case object TIME_RANGE_INVALID
      extends zio.aws.groundstation.model.EphemerisInvalidReason {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason =
      software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason.TIME_RANGE_INVALID
  }
  case object TRAJECTORY_INVALID
      extends zio.aws.groundstation.model.EphemerisInvalidReason {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason =
      software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason.TRAJECTORY_INVALID
  }
  case object KMS_KEY_INVALID
      extends zio.aws.groundstation.model.EphemerisInvalidReason {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason =
      software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason.KMS_KEY_INVALID
  }
  case object VALIDATION_ERROR
      extends zio.aws.groundstation.model.EphemerisInvalidReason {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason =
      software.amazon.awssdk.services.groundstation.model.EphemerisInvalidReason.VALIDATION_ERROR
  }
}
