package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.UnboundedString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EphemerisDescription(
    ephemerisData: Optional[UnboundedString] = Optional.Absent,
    sourceS3Object: Optional[zio.aws.groundstation.model.S3Object] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.EphemerisDescription = {
    import EphemerisDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.EphemerisDescription
      .builder()
      .optionallyWith(
        ephemerisData.map(value =>
          UnboundedString.unwrap(value): java.lang.String
        )
      )(_.ephemerisData)
      .optionallyWith(sourceS3Object.map(value => value.buildAwsValue()))(
        _.sourceS3Object
      )
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.EphemerisDescription.ReadOnly =
    zio.aws.groundstation.model.EphemerisDescription.wrap(buildAwsValue())
}
object EphemerisDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.EphemerisDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.EphemerisDescription =
      zio.aws.groundstation.model.EphemerisDescription(
        ephemerisData.map(value => value),
        sourceS3Object.map(value => value.asEditable)
      )
    def ephemerisData: Optional[UnboundedString]
    def sourceS3Object: Optional[zio.aws.groundstation.model.S3Object.ReadOnly]
    def getEphemerisData: ZIO[Any, AwsError, UnboundedString] =
      AwsError.unwrapOptionField("ephemerisData", ephemerisData)
    def getSourceS3Object
        : ZIO[Any, AwsError, zio.aws.groundstation.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("sourceS3Object", sourceS3Object)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.EphemerisDescription
  ) extends zio.aws.groundstation.model.EphemerisDescription.ReadOnly {
    override val ephemerisData: Optional[UnboundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ephemerisData())
        .map(value =>
          zio.aws.groundstation.model.primitives.UnboundedString(value)
        )
    override val sourceS3Object
        : Optional[zio.aws.groundstation.model.S3Object.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceS3Object())
        .map(value => zio.aws.groundstation.model.S3Object.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.EphemerisDescription
  ): zio.aws.groundstation.model.EphemerisDescription.ReadOnly = new Wrapper(
    impl
  )
}
