package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.{IpV4Address, CapabilityArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DiscoveryData(
    capabilityArns: Iterable[CapabilityArn],
    privateIpAddresses: Iterable[IpV4Address],
    publicIpAddresses: Iterable[IpV4Address]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DiscoveryData = {
    import DiscoveryData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DiscoveryData
      .builder()
      .capabilityArns(capabilityArns.map { item =>
        CapabilityArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .privateIpAddresses(privateIpAddresses.map { item =>
        IpV4Address.unwrap(item): java.lang.String
      }.asJavaCollection)
      .publicIpAddresses(publicIpAddresses.map { item =>
        IpV4Address.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.DiscoveryData.ReadOnly =
    zio.aws.groundstation.model.DiscoveryData.wrap(buildAwsValue())
}
object DiscoveryData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DiscoveryData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DiscoveryData =
      zio.aws.groundstation.model
        .DiscoveryData(capabilityArns, privateIpAddresses, publicIpAddresses)
    def capabilityArns: List[CapabilityArn]
    def privateIpAddresses: List[IpV4Address]
    def publicIpAddresses: List[IpV4Address]
    def getCapabilityArns: ZIO[Any, Nothing, List[CapabilityArn]] =
      ZIO.succeed(capabilityArns)
    def getPrivateIpAddresses: ZIO[Any, Nothing, List[IpV4Address]] =
      ZIO.succeed(privateIpAddresses)
    def getPublicIpAddresses: ZIO[Any, Nothing, List[IpV4Address]] =
      ZIO.succeed(publicIpAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DiscoveryData
  ) extends zio.aws.groundstation.model.DiscoveryData.ReadOnly {
    override val capabilityArns: List[CapabilityArn] = impl
      .capabilityArns()
      .asScala
      .map { item =>
        zio.aws.groundstation.model.primitives.CapabilityArn(item)
      }
      .toList
    override val privateIpAddresses: List[IpV4Address] = impl
      .privateIpAddresses()
      .asScala
      .map { item =>
        zio.aws.groundstation.model.primitives.IpV4Address(item)
      }
      .toList
    override val publicIpAddresses: List[IpV4Address] = impl
      .publicIpAddresses()
      .asScala
      .map { item =>
        zio.aws.groundstation.model.primitives.IpV4Address(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DiscoveryData
  ): zio.aws.groundstation.model.DiscoveryData.ReadOnly = new Wrapper(impl)
}
