package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteEphemerisRequest(ephemerisId: Uuid) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DeleteEphemerisRequest = {
    import DeleteEphemerisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DeleteEphemerisRequest
      .builder()
      .ephemerisId(Uuid.unwrap(ephemerisId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.DeleteEphemerisRequest.ReadOnly =
    zio.aws.groundstation.model.DeleteEphemerisRequest.wrap(buildAwsValue())
}
object DeleteEphemerisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DeleteEphemerisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DeleteEphemerisRequest =
      zio.aws.groundstation.model.DeleteEphemerisRequest(ephemerisId)
    def ephemerisId: Uuid
    def getEphemerisId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(ephemerisId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DeleteEphemerisRequest
  ) extends zio.aws.groundstation.model.DeleteEphemerisRequest.ReadOnly {
    override val ephemerisId: Uuid =
      zio.aws.groundstation.model.primitives.Uuid(impl.ephemerisId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DeleteEphemerisRequest
  ): zio.aws.groundstation.model.DeleteEphemerisRequest.ReadOnly = new Wrapper(
    impl
  )
}
