package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.{Uuid, DataflowEndpointGroupArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataflowEndpointListItem(
    dataflowEndpointGroupArn: Optional[DataflowEndpointGroupArn] =
      Optional.Absent,
    dataflowEndpointGroupId: Optional[Uuid] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DataflowEndpointListItem = {
    import DataflowEndpointListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DataflowEndpointListItem
      .builder()
      .optionallyWith(
        dataflowEndpointGroupArn.map(value =>
          DataflowEndpointGroupArn.unwrap(value): java.lang.String
        )
      )(_.dataflowEndpointGroupArn)
      .optionallyWith(
        dataflowEndpointGroupId.map(value =>
          Uuid.unwrap(value): java.lang.String
        )
      )(_.dataflowEndpointGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.DataflowEndpointListItem.ReadOnly =
    zio.aws.groundstation.model.DataflowEndpointListItem.wrap(buildAwsValue())
}
object DataflowEndpointListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DataflowEndpointListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DataflowEndpointListItem =
      zio.aws.groundstation.model.DataflowEndpointListItem(
        dataflowEndpointGroupArn.map(value => value),
        dataflowEndpointGroupId.map(value => value)
      )
    def dataflowEndpointGroupArn: Optional[DataflowEndpointGroupArn]
    def dataflowEndpointGroupId: Optional[Uuid]
    def getDataflowEndpointGroupArn
        : ZIO[Any, AwsError, DataflowEndpointGroupArn] = AwsError
      .unwrapOptionField("dataflowEndpointGroupArn", dataflowEndpointGroupArn)
    def getDataflowEndpointGroupId: ZIO[Any, AwsError, Uuid] = AwsError
      .unwrapOptionField("dataflowEndpointGroupId", dataflowEndpointGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DataflowEndpointListItem
  ) extends zio.aws.groundstation.model.DataflowEndpointListItem.ReadOnly {
    override val dataflowEndpointGroupArn: Optional[DataflowEndpointGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataflowEndpointGroupArn())
        .map(value =>
          zio.aws.groundstation.model.primitives.DataflowEndpointGroupArn(value)
        )
    override val dataflowEndpointGroupId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.dataflowEndpointGroupId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DataflowEndpointListItem
  ): zio.aws.groundstation.model.DataflowEndpointListItem.ReadOnly =
    new Wrapper(impl)
}
