package zio.aws.groundstation.model
import scala.jdk.CollectionConverters._
sealed trait ConfigCapabilityType {
  def unwrap
      : software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType
}
object ConfigCapabilityType {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType
  ): zio.aws.groundstation.model.ConfigCapabilityType = value match {
    case software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.ANTENNA_DOWNLINK =>
      val r = `antenna-downlink`
      r
    case software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.ANTENNA_DOWNLINK_DEMOD_DECODE =>
      val r = `antenna-downlink-demod-decode`
      r
    case software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.ANTENNA_UPLINK =>
      val r = `antenna-uplink`
      r
    case software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.DATAFLOW_ENDPOINT =>
      val r = `dataflow-endpoint`
      r
    case software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.TRACKING =>
      val r = tracking
      r
    case software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.UPLINK_ECHO =>
      val r = `uplink-echo`
      r
    case software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.S3_RECORDING =>
      val r = `s3-recording`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.ConfigCapabilityType {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType =
      software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.UNKNOWN_TO_SDK_VERSION
  }
  case object `antenna-downlink`
      extends zio.aws.groundstation.model.ConfigCapabilityType {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType =
      software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.ANTENNA_DOWNLINK
  }
  case object `antenna-downlink-demod-decode`
      extends zio.aws.groundstation.model.ConfigCapabilityType {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType =
      software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.ANTENNA_DOWNLINK_DEMOD_DECODE
  }
  case object `antenna-uplink`
      extends zio.aws.groundstation.model.ConfigCapabilityType {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType =
      software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.ANTENNA_UPLINK
  }
  case object `dataflow-endpoint`
      extends zio.aws.groundstation.model.ConfigCapabilityType {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType =
      software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.DATAFLOW_ENDPOINT
  }
  case object tracking
      extends zio.aws.groundstation.model.ConfigCapabilityType {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType =
      software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.TRACKING
  }
  case object `uplink-echo`
      extends zio.aws.groundstation.model.ConfigCapabilityType {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType =
      software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.UPLINK_ECHO
  }
  case object `s3-recording`
      extends zio.aws.groundstation.model.ConfigCapabilityType {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType =
      software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType.S3_RECORDING
  }
}
