package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.VersionString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ComponentVersion(
    componentType: zio.aws.groundstation.model.ComponentType,
    versions: Iterable[VersionString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ComponentVersion = {
    import ComponentVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ComponentVersion
      .builder()
      .componentType(componentType.unwrap)
      .versions(versions.map { item =>
        VersionString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ComponentVersion.ReadOnly =
    zio.aws.groundstation.model.ComponentVersion.wrap(buildAwsValue())
}
object ComponentVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ComponentVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ComponentVersion =
      zio.aws.groundstation.model.ComponentVersion(componentType, versions)
    def componentType: zio.aws.groundstation.model.ComponentType
    def versions: List[VersionString]
    def getComponentType
        : ZIO[Any, Nothing, zio.aws.groundstation.model.ComponentType] =
      ZIO.succeed(componentType)
    def getVersions: ZIO[Any, Nothing, List[VersionString]] =
      ZIO.succeed(versions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ComponentVersion
  ) extends zio.aws.groundstation.model.ComponentVersion.ReadOnly {
    override val componentType: zio.aws.groundstation.model.ComponentType =
      zio.aws.groundstation.model.ComponentType.wrap(impl.componentType())
    override val versions: List[VersionString] = impl
      .versions()
      .asScala
      .map { item =>
        zio.aws.groundstation.model.primitives.VersionString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ComponentVersion
  ): zio.aws.groundstation.model.ComponentVersion.ReadOnly = new Wrapper(impl)
}
