package zio.aws.groundstation.model
import scala.jdk.CollectionConverters._
sealed trait ComponentType {
  def unwrap: software.amazon.awssdk.services.groundstation.model.ComponentType
}
object ComponentType {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.ComponentType
  ): zio.aws.groundstation.model.ComponentType = value match {
    case software.amazon.awssdk.services.groundstation.model.ComponentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.ComponentType.LAMINAR_FLOW =>
      val r = LAMINAR_FLOW
      r
    case software.amazon.awssdk.services.groundstation.model.ComponentType.PRISM =>
      val r = PRISM
      r
    case software.amazon.awssdk.services.groundstation.model.ComponentType.DIGITIZER =>
      val r = DIGITIZER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ComponentType =
      software.amazon.awssdk.services.groundstation.model.ComponentType.UNKNOWN_TO_SDK_VERSION
  }
  case object LAMINAR_FLOW extends zio.aws.groundstation.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ComponentType =
      software.amazon.awssdk.services.groundstation.model.ComponentType.LAMINAR_FLOW
  }
  case object PRISM extends zio.aws.groundstation.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ComponentType =
      software.amazon.awssdk.services.groundstation.model.ComponentType.PRISM
  }
  case object DIGITIZER extends zio.aws.groundstation.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ComponentType =
      software.amazon.awssdk.services.groundstation.model.ComponentType.DIGITIZER
  }
}
