package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AntennaDemodDecodeDetails(
    outputNode: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.AntennaDemodDecodeDetails = {
    import AntennaDemodDecodeDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.AntennaDemodDecodeDetails
      .builder()
      .optionallyWith(outputNode.map(value => value: java.lang.String))(
        _.outputNode
      )
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.AntennaDemodDecodeDetails.ReadOnly =
    zio.aws.groundstation.model.AntennaDemodDecodeDetails.wrap(buildAwsValue())
}
object AntennaDemodDecodeDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.AntennaDemodDecodeDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.AntennaDemodDecodeDetails =
      zio.aws.groundstation.model
        .AntennaDemodDecodeDetails(outputNode.map(value => value))
    def outputNode: Optional[String]
    def getOutputNode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outputNode", outputNode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.AntennaDemodDecodeDetails
  ) extends zio.aws.groundstation.model.AntennaDemodDecodeDetails.ReadOnly {
    override val outputNode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outputNode())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.AntennaDemodDecodeDetails
  ): zio.aws.groundstation.model.AntennaDemodDecodeDetails.ReadOnly =
    new Wrapper(impl)
}
